#
# Standard makefile for creating ASE libraries on Solaris
#

#
# This file needs modification in the following manner :
#
#	1. Add/modify required build rules for your source files
#	2. Change the definitions of ASELIB, ASEOBJ and ASERUT below
#
# Modify the following three lines so that "ASELIB" contains the complete path
# and filename of your target ASE library, "ASEOBJ" contains a space separated
# list of object files which are to be used to create the ASE library, and 
# "ASERUT" contains a space separated list of ASE function names that are 
# exported from your code.
#
# Alternatively, use the concepts shown here to build your own Makefile.
#

ASELIB		= ./asemain
ASEOBJ		= 
ASERUT		=

KERNEL		= /usr/lib/libtdbs.so
C_FLAGS		= -w -fpic -I../include
L_FLAGS		= -G -h -ldl -lc -lm

$(ASELIB): $(ASEOBJ)
	ld -o $(ASELIB) $(ASEOBJ) $(KERNEL) $(L_FLAGS)

.c.o:
	gcc -c $(C_FLAGS) $<
