/****
 *
 * Filename : textase.c
 * Author   : GF
 * Purpose  : To demonstrate two different methods of ASE call from a text
 *	      insert function :
 *		<for <x>
 *		  <box at b(*)+1,1
 *		     field.x
 *		     <t=<call(add, field.x, 0)>>
 *		  >
 *		>
 *		<box at b(*)+1,1
 *		  <t=Total: <call(total, "", 0)>>
 *		>
 ****/

#include <stdio.h>	/* Required for sscanf() */
#include "tripase.h"	/* Required for C ASE routines */

static int current_total = 0;
	
int ASECALL add(char *argstr, int *arglen)
{
  int iVal;

    argstr[*arglen] = '\0';
    sscanf(argstr, "%d", &iVal); /* Get item value */
    current_total += iVal;	 /* Add to total */
    *arglen = 0;		 /* Inhibit item output */
    return( ASE_SUCCESS );
}

int ASECALL total(char *argstr, int *arglen)
{
    /* Set the argument string and length for output */
    *arglen = sprintf(argstr, "%d", current_total);
    return( ASE_SUCCESS );
}
