/****
 *
 * Filename  : submase.c
 * Author    : GF
 * Purpose   : To demonstrate a pre-submit ASE ( VMS only )
 *
 * Simple ASE for pre-submit calling which prints out the arguments sent to it
 * during batch job preparation, and then performs the following operations :
 *
 *	1. If the batch job includes an index cycle, change the reindex mode
 *	   from Y -> N, and vice versa.
 *	2. Set the queue name for the submission to FAST$BATCH
 *
 * Then these parameters are printed out before the job is actually submitted
 * by TRIP.
 *
 ****/

#include <stdio.h>
#include <string.h>

#include "tripase.h"	/* Required by all C ASE routines */

int pre_submit(argstr, arglen)
char *argstr;
int  *arglen;
{
  char base[17], queue[64], cwd[64], reix;
  int  mode;

    /* Zero terminate the input string to allow C runtimes to work */
    argstr[*arglen] = '\0';

    /* Extract the components of the argument string to local variables */
    sscanf(argstr, "%s %d %c %s %s", base, &mode, &reix, queue, cwd);

    /* Print the components to the screen */
    printf("\n\nInput Arguments:\n----------------\n");
    printf("\nBase\t: %s", base);
    printf("\nMode\t: %d", mode);
    if( mode == SUBMIT_MODE_INDEX || mode == SUBMIT_MODE_LOADIX )
      printf("\nReindex\t: %c", reix);
    printf("\nQueue\t: %s", queue);
    printf("\nCWD\t: %s\n", cwd);


    /* If job includes an index, switch the reindex flag */
    if( mode = SUBMIT_MODE_INDEX || mode == SUBMIT_MODE_LOADIX )
    if( reix == 'Y' ) reix = 'N'; else reix = 'Y';

    /* Set the submit queue to FAST$BATCH */
    strcpy(queue, "FAST$BATCH");

    /* Print the new components to the screen */
    printf("\n\nOutput Arguments:\n----------------\n");
    printf("\nBase\t: %s", base);
    printf("\nMode\t: %d", mode);
    if( mode == SUBMIT_MODE_INDEX || mode == SUBMIT_MODE_LOADIX )
      printf("\nReindex\t: %c", reix);
    printf("\nQueue\t: %s", queue);
    printf("\nCWD\t: %s\n", cwd);

    /* Set the return argument string and length */
    *arglen = sprintf(argstr, "%s %d %c %s %s", base, mode, reix, queue, cwd);

    /* Return a success code to indicate that the job should be submitted */
    return ASE_SUCCESS;
}
