/*******************************************************************************
 *
 * Filename  : tripase.h
 * Copyright : infinIT Services GmbH 2018 - all rights reserved
 * Purpose   : Standard header file for ASE programming with TRIP
 * Requires  : Windows : #include <windows.h> first
 *             Others  : none
 * History   :
 *	940504	GF	Created
 *       040401  JS      Updated to Trip4 and fixed B0399
 *
 *******************************************************************************/

#ifndef __TRIP_ASE__
#define __TRIP_ASE__

#ifdef __cplusplus
extern "C" {
#endif

/* Definition of the ASECALL macro required for ASEs in Windows */

#ifdef _MSC_VER
#define ASECALL __stdcall
#else
#define ASECALL
#endif

/* General return code bits */

#define ASE_FAIL	0
#define ASE_SUCCESS	1


/* TRIPclassic data entry specific return code bits */

#define ASE_REFRESH	2	/* Refresh screen upon return from ASE	      */
#define ASE_CONTINUE	4	/* Continue with previous keyboard action     */
#define ASE_MESSAGE	8	/* Flush any pending messages		      */
#define ASE_FIXFIELD	16	/* Fix the cursor to the last field used      */
#define ASE_NOFIELD	32	/* Disallow any data entry to fields on page  */


/* Submit ASE modes */

#define SUBMIT_MODE_LOADIX	1
#define SUBMIT_MODE_INDEX	2
#define SUBMIT_MODE_LOAD	3
#define SUBMIT_MODE_PRINT	4
#define SUBMIT_MODE_GLBUPD	5


#ifndef IsError
#define IsError(x)	( !( (x) & 1 ) )
#endif

#ifndef IsSuccess
#define IsSuccess(x)	( (x) & 1 )
#endif

/* Manifest constants for use in TdbBaffitMode() and TedCheckMode() functions */

#ifndef __TRIPbase_H__

#define RECORD_LEVEL	1
#define PART_LEVEL	2	/* Not supported yet */
#define FIELD_LEVEL	3	/* Not supported yet */

#define ADD_MODE	1
#define MODIFY_MODE	2
#define DELETE_MODE	3

#endif		/* __TRIPbase_H__ */

/* Manifest constants for TdbLoadStatus() */

#ifndef LOAD_STATUS_DELETE_SEARCHES
#define LOAD_STATUS_DELETE_SEARCHES	2
#endif

#ifndef LOAD_STATUS_REOPEN_BASES
#define LOAD_STATUS_REOPEN_BASES	1
#endif


/* Manifest constants for TdbMessage() */

#ifndef MSG_HAS_TEXT
#define MSG_HAS_TEXT	32
#endif

#ifndef MSG_SET_ERROR
#define MSG_SET_ERROR	-1
#endif

/* Type definitions required to use the ASE routine callback functions 	      */

#ifndef __TRIPbase_H__

typedef void *tdb_handle, *TdbHandle;

#endif	/* __TRIPbase_H */

/* Work out if prototypes are required / supported by the compiler */

#if defined(__cplusplus) || defined(_MSC_VER) || defined(__STDC__)
#       define _USE_TRIP_PROTOTYPES 1
#       define TRIPapi extern int
#else
#       define _USE_TRIP_PROTOTYPES 0
#endif

#ifndef __TRIPapi_PROTOTYPES__

#ifdef _USE_TRIP_PROTOTYPES

TRIPapi TdbBaffitMode(void);
TRIPapi TdbCurrentItem(char*, TdbHandle*, int*, int*, int*, int*, int*);
TRIPapi TdbLoadStatus(int);
TRIPapi TdbMessage(int, char*, int*);
TRIPapi TdbSaveStatus(void);

#endif	/* _USE_TRIP_PROTOTYPES */

#endif	/* __TRIPapi_PROTOTYPES__ */

/* TRIPclassic data entry / search form specific callback functions	      */

#ifdef _USE_TRIP_PROTOTYPES

TRIPapi TedCheckEntry(int*, int*);
TRIPapi TedCheckMode(int);
TRIPapi TedSetEntry(int, int);
TRIPapi TedGetLine(char*, int*);
TRIPapi TedPutLine(char*, int);
TRIPapi TedWriteMessage(char*, int, int);
TRIPapi TedClearSform();

#endif	/* _USE_TRIP_PROTOTYPES */

#ifdef __cplusplus
}
#endif

#endif	/* __TRIP_ASE__ */
