/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import ag.smaser.trip.filefilter.tikasrv.BasicLogger;
import ag.smaser.trip.filefilter.tikasrv.ByteBufferInputStream;
import ag.smaser.trip.filefilter.tikasrv.ChunkedWriter;
import ag.smaser.trip.filefilter.tikasrv.NioInputStream;
import ag.smaser.trip.filefilter.tikasrv.NioOutputStream;
import ag.smaser.trip.filefilter.tikasrv.TikaDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.tika.io.TikaInputStream;

class NioClientRequest
implements Runnable {
    private SocketChannel client;
    private boolean interrupted;
    private final BasicLogger logger;
    private final String id;
    private int maxFileSize;
    static int LAST_JOB_ID = 0;

    NioClientRequest(SocketChannel client, BasicLogger logger, int maxFileSize) throws IOException {
        this.client = client;
        this.logger = logger;
        this.maxFileSize = maxFileSize;
        this.interrupted = false;
        this.id = "REQ#" + Integer.toString(++LAST_JOB_ID);
        client.configureBlocking(false);
        client.socket().setTcpNoDelay(true);
        logger.info(this.id, "Job submitted");
    }

    private String formatHeader(int code, String message, String contentType, int contentSize, boolean moreHeaders) {
        String h = "HTTP/1.1 " + Integer.toString(code) + " " + message + "\r\nContent-Type: " + contentType + "\r\nContent-Length: " + Integer.toString(contentSize) + "\r\n";
        if (!moreHeaders) {
            h = h + "\r\n";
        }
        return h;
    }

    private String formatChunkHeader(int compressmode) {
        String h = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nTransfer-Encoding: ";
        h = compressmode == 1 ? h + "gzip, chunked\r\n" : (compressmode == 2 ? h + "deflate, chunked\r\n" : h + "chunked\r\n");
        h = h + "Trailer: X-TIKASRV-PROPERTY X-TIKASRV-DONE X-TIKASRV-MESSAGE\r\n";
        return h + "\r\n";
    }

    boolean wasInterrupted() {
        return this.interrupted;
    }

    void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NioOutputStream os;
        NioInputStream is;
        int nState = 1;
        boolean extractText = false;
        boolean extractProperties = false;
        boolean sendContinue = false;
        boolean returnStatus = false;
        String header = null;
        String contentType = null;
        boolean success = false;
        OutputStream filestream = null;
        byte[] block = new byte[32768];
        int expectedLength = -1;
        String inputFileName = null;
        String extension = null;
        byte[] bodytext = null;
        boolean bDone = false;
        boolean bChunked = false;
        TikaDriver tika = null;
        File tempFile = null;
        this.logger.info(this.id, "Started processing job");
        try {
            is = new NioInputStream(this.client, this.logger, this.id);
            os = new NioOutputStream(this.client, this.logger, this.id);
        }
        catch (Exception ex) {
            this.logger.error(this.id, ex);
            if (ex instanceof InterruptedException) {
                this.interrupted = true;
                this.logger.warn(this.id, "Thread was interrupted.");
            } else {
                this.logger.error(this.id, "Request processing exiting prematurely due to initialization error.");
            }
            return;
        }
        do {
            try {
                switch (nState) {
                    case 1: {
                        this.logger.debug(this.id, "Reading request header");
                        String strLine = is.readHttpHeaderLine();
                        this.logger.debug(this.id, strLine);
                        if (strLine.startsWith("PUT /text+meta")) {
                            extractProperties = true;
                            extractText = true;
                        } else if (strLine.startsWith("PUT /text")) {
                            extractText = true;
                        } else if (strLine.startsWith("PUT /meta")) {
                            extractProperties = true;
                        } else if (strLine.startsWith("GET /status")) {
                            returnStatus = true;
                        } else {
                            header = !strLine.startsWith("PUT ") ? this.formatHeader(405, "Invalid method", "text/plain", 0, false) : this.formatHeader(404, "Not found", "text/plain", 0, false);
                            this.logger.error(this.id, header);
                            nState = 3;
                            break;
                        }
                        expectedLength = 0;
                        inputFileName = null;
                        while (nState == 1 && (strLine = is.readHttpHeaderLine()) != null) {
                            if (strLine.length() > 0 && this.logger.isActive(BasicLogger.LEVEL_DEBUG)) {
                                this.logger.debug(this.id, strLine);
                            }
                            if (strLine.length() == 0) {
                                nState = 2;
                                continue;
                            }
                            if (strLine.startsWith("Expect:")) {
                                if (!strLine.substring(7).trim().equalsIgnoreCase("100-continue")) continue;
                                sendContinue = true;
                                continue;
                            }
                            if (strLine.startsWith("Content-Length:")) {
                                expectedLength = Integer.parseInt(strLine.substring(15).trim());
                                continue;
                            }
                            if (strLine.startsWith("Content-Type:")) {
                                contentType = strLine.substring(13).trim();
                                if (!contentType.equals("application/octet-stream")) continue;
                                contentType = null;
                                continue;
                            }
                            if (!strLine.startsWith("Content-Disposition: attachment; filename=")) continue;
                            int idx = strLine.indexOf(61);
                            String fn = strLine.substring(idx + 1).trim();
                            if (fn.startsWith("\"") && fn.endsWith("\"")) {
                                fn = fn.substring(1, fn.length() - 1);
                            }
                            if ((idx = (inputFileName = URLDecoder.decode(fn, "UTF-8")).lastIndexOf(46)) <= 0) continue;
                            extension = inputFileName.substring(idx);
                        }
                        if (sendContinue) {
                            this.logger.info(this.id, "Sending 100-Continue as requested by client");
                            header = this.formatHeader(100, "Continue", "text/plain", 0, false);
                            os.write(header.getBytes());
                        }
                        if (returnStatus) {
                            this.logger.info(this.id, "Preparing status response");
                            bodytext = "Tika Server is running".getBytes("UTF-8");
                            header = this.formatHeader(200, "OK", "text/plain", bodytext.length, false);
                            nState = 3;
                            success = true;
                        } else if (1 == nState) {
                            header = this.formatHeader(400, "No file data provided for analysis", "text/plain", 0, false);
                            nState = 3;
                        } else if (inputFileName == null) {
                            header = this.formatHeader(400, "Content disposition (filename) not specified", "text/plain", 0, false);
                            nState = 3;
                        }
                        if (expectedLength == -1) {
                            expectedLength = Integer.MAX_VALUE;
                            this.logger.warn(this.id, "No Content-Length received as part of request.");
                            break;
                        }
                        if (expectedLength > 0) {
                            this.logger.debug(this.id, "Expecting " + Integer.toString(expectedLength) + " bytes of file data.");
                            break;
                        }
                        header = this.formatHeader(200, "OK", "text/plain", 0, true);
                        header = header + "X-TIKASRV-DONE: 1\r\nX-TIKASRV-MESSAGE: OK\r\n\r\n";
                        success = true;
                        nState = 3;
                        break;
                    }
                    case 2: {
                        int blocksz;
                        int bufferedsize = 0;
                        int n = blocksz = block.length < expectedLength ? block.length : expectedLength;
                        if (expectedLength > 0 && expectedLength < Integer.MAX_VALUE) {
                            int bytesread;
                            ByteBuffer filebuffer;
                            this.logger.debug(this.id, "Reading file data: " + inputFileName);
                            if (expectedLength <= this.maxFileSize) {
                                this.logger.debug(this.id, "Preallocating memory");
                                filebuffer = ByteBuffer.allocateDirect(expectedLength);
                                filestream = null;
                            } else {
                                this.logger.debug(this.id, "File is larger than " + Integer.toString(this.maxFileSize) + " - using temp file");
                                filebuffer = null;
                                tempFile = File.createTempFile("tvx", extension);
                                filestream = new FileOutputStream(tempFile);
                            }
                            this.logger.debug(this.id, "Entering read loop");
                            while (blocksz > 0 && (bytesread = is.read(block, 0, blocksz)) > 0) {
                                this.logger.debug(this.id, "Read " + Integer.toString(bytesread) + " bytes");
                                if (filebuffer != null) {
                                    filebuffer.put(block, 0, bytesread);
                                } else {
                                    filestream.write(block, 0, bytesread);
                                }
                                blocksz = block.length < expectedLength - (bufferedsize += bytesread) ? block.length : expectedLength - bufferedsize;
                            }
                            this.logger.debug(this.id, Integer.toString(bufferedsize) + " bytes of file data received");
                            if (bufferedsize != expectedLength) {
                                this.logger.warn(this.id, "Expected length " + Integer.toString(expectedLength) + ", but received " + Integer.toString(bufferedsize) + " bytes.");
                            }
                            if (filebuffer != null) {
                                this.logger.debug(this.id, "Initializing TikaDriver with a TikaInputStream wrapping the file data ByteBuffer.");
                                ((Buffer)filebuffer).rewind();
                                tika = new TikaDriver(inputFileName, (InputStream)TikaInputStream.get((InputStream)new ByteBufferInputStream(filebuffer)), contentType, this.logger, this.id);
                            } else {
                                this.logger.debug(this.id, "Initializing TikaDriver with temporary file");
                                filestream.flush();
                                filestream.close();
                                filestream = null;
                                tika = new TikaDriver(inputFileName, tempFile, contentType, this.logger, this.id);
                            }
                        } else {
                            this.logger.debug(this.id, "Initializing TikaDriver with TikaInputStream wrapping the socket stream");
                            tika = new TikaDriver(inputFileName, (InputStream)TikaInputStream.get((InputStream)is), contentType, this.logger, this.id);
                        }
                        this.logger.info(this.id, "Parsing the file data using Apache Tika, job ID=" + this.id);
                        int compressmode = 0;
                        ChunkedWriter chunkw = new ChunkedWriter(os, 8192, !extractText, this.logger, this.id, compressmode);
                        tika.setWriter(chunkw);
                        bChunked = true;
                        os.write(this.formatChunkHeader(compressmode).getBytes("UTF-8"));
                        tika.parse(extractText, extractProperties);
                        if (extractText) {
                            this.logger.debug(this.id, "Flushing remaining text chunk");
                            chunkw.flush();
                        }
                        this.logger.debug(this.id, "Writing chunk terminator");
                        header = "0\r\n";
                        os.write(header.getBytes("UTF-8"));
                        header = "";
                        if (extractProperties) {
                            String[] names = tika.getPropertyNames();
                            this.logger.debug(this.id, Integer.toString(names.length) + " properties found");
                            for (String name : names) {
                                String hdrline = "X-TIKASRV-PROPERTY: " + name + "=" + tika.getProperty(name);
                                header = header + hdrline + "\r\n";
                                if (!this.logger.isActive(BasicLogger.LEVEL_EXTRADEBUG)) continue;
                                this.logger.extraDebug(this.id, hdrline);
                            }
                        } else {
                            this.logger.debug(this.id, "No properties were requested");
                        }
                        success = true;
                        header = header + "X-TIKASRV-DONE: 1\r\nX-TIKASRV-MESSAGE: OK\r\n\r\n";
                        this.logger.debug(this.id, "Writing trailer");
                        os.write(header.getBytes("UTF-8"));
                        this.logger.info(this.id, "Job response sent");
                        nState = 99;
                        break;
                    }
                    case 3: {
                        this.logger.info(this.id, "Sending response for job");
                        os.write(header.getBytes("UTF-8"));
                        if (!success) {
                            nState = 99;
                            this.logger.warn(this.id, "Error writing response header");
                            break;
                        }
                        nState = 4;
                        this.logger.debug(this.id, "Response header written");
                        break;
                    }
                    case 4: {
                        if (returnStatus) {
                            this.logger.debug(this.id, "Sending status response");
                        } else {
                            this.logger.debug(this.id, "Writing extracted text");
                        }
                        if (bodytext != null && bodytext.length > 0) {
                            os.write(bodytext);
                            if (!returnStatus) {
                                this.logger.debug(this.id, "Wrote response body (" + Integer.toString(bodytext.length) + " bytes)");
                            }
                        }
                        nState = 99;
                        break;
                    }
                    case 99: {
                        bDone = true;
                    }
                }
                if (bDone) continue;
                Thread.sleep(5L);
            }
            catch (Throwable x) {
                if (x instanceof InterruptedException) {
                    this.logger.warn(this.id, "Sender thread was interrupted.");
                } else {
                    this.logger.error(this.id, x);
                }
                try {
                    String trail = "";
                    for (Throwable y = x; y != null; y = y.getCause()) {
                        trail = trail + y.getMessage() + "\r\n";
                    }
                    if (bChunked) {
                        header = "0\r\n";
                        header = header + "X-TIKASRV-DONE: 0\r\n";
                        if (trail.length() > 250) {
                            trail = trail.substring(0, 245);
                        }
                        header = header + "X-TIKASRV-MESSAGE: Exception " + trail.replace('\r', ' ').replace('\n', ' ') + "\r\n\r\n";
                        os.write(header.getBytes("UTF-8"));
                    } else {
                        byte[] errbody = trail.getBytes("UTF8");
                        os.write(this.formatHeader(500, "Internal Server Error", "text/plain", errbody.length, false).getBytes());
                        os.write(errbody);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                bDone = true;
            }
            finally {
                if (tika != null) {
                    tika.close();
                }
                if (filestream != null) {
                    try {
                        filestream.close();
                    }
                    catch (IOException compressmode) {}
                    filestream = null;
                }
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                    tempFile = null;
                }
            }
        } while (!bDone);
        try {
            os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
        this.logger.info(this.id, "Done processing job");
    }
}

