/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import ag.smaser.trip.filefilter.tikasrv.BasicLogger;
import ag.smaser.trip.filefilter.tikasrv.NioServer;
import ag.smaser.trip.filefilter.tikasrv.TikaDriver;
import java.io.FileInputStream;
import java.io.IOException;

public class Main {
    private static void usage() {
        System.out.println("USAGE: tikasrv [OPTIONS]");
        System.out.println();
        System.out.println("OPTIONS:");
        System.out.println("   -p port         TCP port at which to listen");
        System.out.println("   -l loglevel     Logging level (0-6)");
        System.out.println("   -f logfile      Log file name (otherwise stdout)");
        System.out.println("   -w maxworkers   Max number of worker threads to start (default: 10)");
        System.out.println("   -z maxfilesize  Max size of file to keep in memory (default 20MB)");
        System.out.println("   -i file         Run interactively w/o HTTP server");
        System.out.println("   -t contentType  Optional content type (for use with -i)");
        System.out.println("   -m class        Display supported media types for a specified Tika parser");
        System.out.println();
        System.out.flush();
    }

    private static int parseSize(String szarg) {
        int value = 0;
        for (int i = 0; i < szarg.length(); ++i) {
            char c = szarg.charAt(i);
            if (Character.isDigit(c)) {
                value *= 10;
                value += c - 48;
                continue;
            }
            String sfx = szarg.substring(i).toLowerCase();
            if (sfx.equals("kb")) {
                value *= 1000;
                break;
            }
            if (sfx.equals("kib")) {
                value *= 1024;
                break;
            }
            if (sfx.equals("mb")) {
                value *= 1000000;
                break;
            }
            if (sfx.equals("mib")) {
                value *= 0x100000;
                break;
            }
            if (sfx.equals("gb")) {
                value *= 1000000000;
                break;
            }
            if (sfx.equals("gib")) {
                value *= 0x40000000;
                break;
            }
            throw new IllegalArgumentException("Not a valid size suffix: \"" + sfx + "\"");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BasicLogger logger;
        int loglevel = 3;
        int port = 9998;
        String logfile = null;
        String infile = null;
        String ct = null;
        String parserClass = null;
        int workers = 10;
        int maxfilesize = 20000000;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-p") && i + 1 < args.length) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-l") && i + 1 < args.length) {
                loglevel = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-w") && i + 1 < args.length) {
                workers = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-z") && i + 1 < args.length) {
                maxfilesize = Main.parseSize(args[++i]);
                continue;
            }
            if (args[i].equals("-i") && i + 1 < args.length) {
                infile = args[++i];
                continue;
            }
            if (args[i].equals("-f") && i + 1 < args.length) {
                logfile = args[++i];
                continue;
            }
            if (args[i].equals("-t") && i + 1 < args.length) {
                ct = args[++i];
                continue;
            }
            if (args[i].equals("-m") && i + 1 < args.length) {
                parserClass = args[++i];
                continue;
            }
            Main.usage();
            return;
        }
        if (loglevel < 0) {
            loglevel = 0;
        } else if (loglevel > 6) {
            loglevel = 6;
        }
        if (port <= 0) {
            port = 9998;
        }
        if (workers < 1) {
            workers = 1;
        }
        try {
            logger = logfile != null ? new BasicLogger(logfile, loglevel) : new BasicLogger(loglevel);
        }
        catch (IOException ignore) {
            logger = new BasicLogger(0);
        }
        if (parserClass != null) {
            try {
                TikaDriver.showMediaTypes(parserClass);
            }
            catch (Exception x) {
                logger.fatal(null, x);
                logger.close();
                System.exit(1);
            }
        } else if (infile == null) {
            NioServer srv = null;
            try {
                srv = new NioServer(logger, port, workers);
                srv.setMaxFileSize(maxfilesize);
            }
            catch (IOException x) {
                logger.fatal(null, x);
                logger.fatal(null, "Unable to initialize the HTTP server");
                logger.close();
                System.exit(1);
            }
            logger.info(null, "Starting the HTTP Server...");
            srv.start();
            do {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException iox) {
                    logger.debug(null, "Caught an InterruptedException");
                }
            } while (srv.isAlive());
            logger.info(null, "tikasrv is done");
        } else {
            try (TikaDriver tika = null;){
                tika = new TikaDriver(infile, new FileInputStream(infile), ct, logger, "TIKASRV");
                tika.parse(true, false);
                System.out.println(tika.getText());
            }
        }
        logger.close();
    }
}

