/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import ag.smaser.trip.filefilter.tikasrv.BasicLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;

public class ChunkedWriter
extends Writer {
    private OutputStream m_os;
    private int m_chunksize;
    private StringBuilder m_buffer;
    private CharsetEncoder m_enc;
    Deflater m_zz;
    GZIPOutputStream m_gz = null;
    ByteArrayOutputStream m_gzdata;
    byte[] m_bzdata;
    private boolean m_silent;
    private BasicLogger m_logger;
    private String m_logid;
    private int m_laps;
    private boolean m_deflate;
    private boolean m_gzip;
    public static final int COMPRESS_NONE = 0;
    public static final int COMPRESS_GZIP = 1;
    public static final int COMPRESS_DEFLATE = 2;

    ChunkedWriter(OutputStream os, int chunksize, boolean noemit, BasicLogger logger, String id, int compressmode) {
        this.m_os = os;
        this.m_chunksize = chunksize < 1024 ? 1024 : chunksize;
        this.m_buffer = new StringBuilder(this.m_chunksize * 32);
        this.m_enc = StandardCharsets.UTF_8.newEncoder();
        this.m_gzip = compressmode == 1;
        boolean bl = this.m_deflate = !this.m_gzip && compressmode == 2;
        if (this.m_deflate) {
            this.m_zz = new Deflater(1);
            this.m_bzdata = new byte[this.m_chunksize * 32];
        }
        if (this.m_gzip) {
            this.m_gzdata = new ByteArrayOutputStream(this.m_chunksize * 32);
        }
        this.m_silent = noemit;
        this.m_logger = logger;
        this.m_logid = id;
        this.m_laps = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.m_deflate) {
            this.m_zz.end();
        }
    }

    @Override
    public void flush() throws IOException {
        this.emit(true);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.m_logger.debug(this.m_logid, "ChunkedWriter.write() called for " + Integer.toString(len) + " extracted characters");
        this.m_buffer.append(cbuf, off, len);
        if (this.m_buffer.length() >= this.m_chunksize) {
            this.emit(false);
            ++this.m_laps;
            if (this.m_laps >= 20) {
                Runtime.getRuntime().gc();
                this.m_laps = 0;
            }
        }
    }

    private void emit(boolean last) throws IOException {
        if (this.m_deflate) {
            this.emitDeflated(last);
        } else if (this.m_gzip) {
            this.emitGZipped(last);
        } else {
            this.emitNormal(last);
        }
    }

    private void emitDeflated(boolean last) throws IOException {
        if (this.m_buffer.length() == 0) {
            return;
        }
        try {
            String trailer;
            String string = trailer = last ? "" : this.splitAtNewline();
            if (this.m_zz.needsInput() && this.m_buffer.length() > 0) {
                byte[] ba = this.m_buffer.toString().getBytes("UTF-8");
                this.m_zz.setInput(ba);
                this.m_buffer.setLength(0);
            }
            if (trailer.length() > 0) {
                this.m_buffer.append(trailer);
            }
            if (last) {
                this.m_zz.finish();
            }
            int zlen = this.m_zz.deflate(this.m_bzdata, 0, this.m_bzdata.length, last ? 3 : 0);
            if (!this.m_silent && last) {
                this.m_logger.debug(this.m_logid, "Last chunk is " + Integer.toString(zlen) + " bytes");
            }
            if (!this.m_silent && (last && zlen > 0 || zlen > this.m_chunksize)) {
                this.m_logger.debug(this.m_logid, "Emitting deflate-chunk with " + Integer.toString(zlen) + " bytes");
                String hh = Integer.toHexString(zlen) + "\r\n";
                this.m_os.write(hh.getBytes("UTF-8"));
                this.m_os.write(this.m_bzdata, 0, zlen);
                this.m_os.write("\r\n".getBytes("UTF-8"));
            } else if (zlen > 0) {
                this.m_logger.debug(this.m_logid, "Skipping chunk emission (running silent or not enough data)");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new IOException(x);
        }
    }

    private void emitGZipped(boolean last) throws IOException {
        try {
            String trailer;
            if (this.m_gzip && null == this.m_gz) {
                this.m_gz = new GZIPOutputStream((OutputStream)this.m_gzdata, this.m_chunksize * 32, true);
            }
            String string = trailer = last ? "" : this.splitAtNewline();
            if (this.m_buffer.length() > 0) {
                byte[] ba = this.m_buffer.toString().getBytes("UTF-8");
                this.m_gz.write(ba, 0, ba.length);
                this.m_buffer.setLength(0);
            }
            if (trailer.length() > 0) {
                this.m_buffer.append(trailer);
            }
            if (last) {
                this.m_gz.finish();
                this.m_gz.flush();
            }
            int zlen = this.m_gzdata.size();
            if (!this.m_silent && last) {
                this.m_logger.debug(this.m_logid, "Last chunk is " + Integer.toString(zlen) + " bytes");
            }
            if (!this.m_silent && (last && zlen > 0 || zlen > this.m_chunksize)) {
                this.m_logger.debug(this.m_logid, "Emitting gzip-chunk with " + Integer.toString(zlen) + " bytes");
                String hh = Integer.toHexString(zlen) + "\r\n";
                this.m_os.write(hh.getBytes("UTF-8"));
                this.m_gzdata.writeTo(this.m_os);
                this.m_os.write("\r\n".getBytes("UTF-8"));
                this.m_gzdata.reset();
            } else if (zlen > 0) {
                this.m_logger.debug(this.m_logid, "Skipping chunk emission (running silent or not enough data)");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new IOException(x);
        }
    }

    private void emitNormal(boolean last) throws IOException {
        if (this.m_buffer.length() == 0) {
            return;
        }
        try {
            String trailer = last ? "" : this.splitAtNewline();
            byte[] ba = this.m_buffer.toString().getBytes("UTF-8");
            this.m_logger.info(this.m_logid, "Emitting chunk with " + Integer.toString(ba.length) + " bytes");
            this.m_buffer.setLength(0);
            if (trailer.length() > 0) {
                this.m_buffer.append(trailer);
            }
            if (!this.m_silent && ba.length > 0) {
                String hh = Integer.toHexString(ba.length) + "\r\n";
                this.m_os.write(hh.getBytes("UTF-8"));
                this.m_os.write(ba, 0, ba.length);
                this.m_os.write("\r\n".getBytes("UTF-8"));
            } else {
                this.m_logger.info(this.m_logid, "Skipping chunk emission (running silent or no data)");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new IOException(x);
        }
        this.m_logger.info(this.m_logid, "Emit done");
    }

    private String splitAtNewline() {
        String trailer = "";
        int lastnl = this.m_buffer.lastIndexOf("\n");
        if (lastnl >= 0) {
            while (lastnl + 1 < this.m_buffer.length() && Character.isWhitespace(this.m_buffer.charAt(lastnl + 1))) {
                ++lastnl;
            }
            if (lastnl + 1 >= this.m_buffer.length()) {
                lastnl = -1;
            }
        }
        if (lastnl != -1) {
            trailer = this.m_buffer.substring(lastnl + 1);
            this.m_buffer.setLength(this.m_buffer.length() - trailer.length() - 1);
        }
        return trailer;
    }
}

