/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.example;

import ag.smaser.trip.filefilter.AdapterOutputType;
import ag.smaser.trip.filefilter.Conversion;
import ag.smaser.trip.filefilter.ConvertAbility;
import ag.smaser.trip.filefilter.FileFilterException;
import ag.smaser.trip.filefilter.FilterAdapter;
import ag.smaser.trip.filefilter.FilterReturnCode;
import java.io.DataInputStream;
import java.io.IOException;

public class ExampleAdapter
extends FilterAdapter {
    private DataInputStream m_stream = null;

    public ConvertAbility checkConversion(AdapterOutputType adapterOutputType, String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return ConvertAbility.Maybe;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        if ((string2.equals("txt") || string2.equals("conf") || string2.equals("ini")) && adapterOutputType == AdapterOutputType.Text) {
            return ConvertAbility.Yes;
        }
        return ConvertAbility.No;
    }

    public void openConversion(Conversion conversion) throws FileFilterException {
        try {
            this.m_stream = new DataInputStream(conversion.getInputStream());
        }
        catch (Exception exception) {
            throw new FileFilterException(FilterReturnCode.CouldNotOpen, "Unable to create DataInputStream", (Throwable)exception);
        }
    }

    public void closeConversion(Conversion conversion) throws FileFilterException {
        if (this.m_stream != null) {
            try {
                this.m_stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_stream = null;
        }
    }

    public void convert(Conversion conversion, String string) throws FileFilterException {
        byte[] byArray = null;
        int n = 0;
        if (null == this.m_stream) {
            throw new FileFilterException(FilterReturnCode.InvalidArgument, "Conversion has not been opened.");
        }
        if (conversion.getOutputType() != AdapterOutputType.Text) {
            throw new FileFilterException(FilterReturnCode.InvalidOutputType, "Unexpected output format");
        }
        try {
            byArray = new byte[1024];
            while ((n = this.m_stream.read(byArray)) > 0) {
                this.addConversionResult(conversion, byArray, n);
            }
        }
        catch (IOException iOException) {
            throw new FileFilterException(FilterReturnCode.ConversionError, "Unable to read UTF data from input stream", (Throwable)iOException);
        }
    }
}

