/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.cfw;

import ag.smaser.trip.cfw.ChangeType;
import ag.smaser.trip.cfw.ConnectorException;
import ag.smaser.trip.cfw.ConnectorReturnCode;
import ag.smaser.trip.cfw.ImportValue;
import ag.smaser.trip.cfw.ItemLink;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportItem {
    private String id = "";
    private String oldid = "";
    private ChangeType change = ChangeType.Updated;
    private Date timestamp = null;
    private Date expires = null;
    private String checksum = "";
    private HashMap<String, String> properties = new HashMap();
    private List<ImportValue> values = new ArrayList<ImportValue>();
    private List<ItemLink> links = new ArrayList<ItemLink>();

    public ImportItem(String string) {
        this.id = string;
    }

    public ImportItem(String string, ChangeType changeType, String string2) throws ConnectorException {
        if (changeType == ChangeType.Renamed && (string2 == null || string2.length() == 0)) {
            throw new ConnectorException(ConnectorReturnCode.InvalidArgument, "Old item ID is required for renames.");
        }
        this.id = string;
        this.change = changeType;
        this.oldid = string2 == null ? "" : string2;
    }

    public String getId() {
        return this.id;
    }

    public String getOldId() {
        return this.id;
    }

    public ChangeType getChangeType() {
        return this.change;
    }

    public int getChangeCode() {
        return this.change.getCode();
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setChecksum(String string) {
        this.checksum = string;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void addValue(ImportValue importValue) {
        this.values.add(importValue);
    }

    public void addLink(ItemLink itemLink) {
        this.links.add(itemLink);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }
}

