/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.cfw;

import ag.smaser.trip.cfw.ChangeType;
import ag.smaser.trip.cfw.ConnectorException;
import ag.smaser.trip.cfw.ConnectorReturnCode;
import ag.smaser.trip.cfw.ImportItem;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;

public abstract class ImportConnector {
    private ConnectorReturnCode m_eErrorCode = ConnectorReturnCode.Success;
    private String m_strErrorText = "";
    private Charset m_enc = null;
    private HashMap<String, String> m_properties = new HashMap();
    private long m_nNativeInfo = 0L;
    private static boolean m_bInitialized = false;

    protected ImportConnector() {
        try {
            this.setTextEncoding("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int initializeConnector() throws ConnectorException {
        this.setError(ConnectorReturnCode.Success, "");
        return this.m_eErrorCode.getCode();
    }

    public int uninitializeConnector() throws ConnectorException {
        this.setError(ConnectorReturnCode.Success, "");
        return this.m_eErrorCode.getCode();
    }

    public abstract Object connect(boolean var1) throws ConnectorException;

    public abstract void disconnect(Object var1);

    public abstract ImportItem firstItem(Object var1);

    public abstract ImportItem nextItem(Object var1);

    public abstract ChangeType checkItem(Object var1, ImportItem var2) throws ConnectorException;

    public abstract int loadItem(Object var1, ImportItem var2);

    public final int getLastConnectorErrorCode() {
        return this.m_eErrorCode.getCode();
    }

    public final String getLastConnectorError() {
        return this.m_strErrorText;
    }

    public final void setTextEncoding(String string) throws ConnectorException {
        try {
            this.m_enc = Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            this.setError(ConnectorReturnCode.InvalidArgument, illegalCharsetNameException.toString());
            throw new ConnectorException(ConnectorReturnCode.InvalidArgument, "Unable to assign text encoding (illegal).", illegalCharsetNameException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            this.setError(ConnectorReturnCode.InvalidArgument, unsupportedCharsetException.toString());
            throw new ConnectorException(ConnectorReturnCode.InvalidArgument, "Unable to assign text encoding (unsupported).", unsupportedCharsetException);
        }
        catch (Exception exception) {
            this.setError(ConnectorReturnCode.Unknown, exception.toString());
            throw new ConnectorException(ConnectorReturnCode.InvalidArgument, "Unable to assign text encoding.", exception);
        }
    }

    public final Charset getTextEncoding() {
        return this.m_enc;
    }

    public final int setConnectorProperty(String string, String string2) {
        this.setError(ConnectorReturnCode.Success, "");
        try {
            this.m_properties.put(string, string2);
        }
        catch (Exception exception) {
            this.setError(ConnectorReturnCode.Unknown, exception.toString());
        }
        return this.m_eErrorCode.getCode();
    }

    public boolean hasConnectorProperty(String string) {
        return this.m_properties.containsKey(string);
    }

    public String getConnectorProperty(String string) {
        if (this.hasConnectorProperty(string)) {
            return this.m_properties.get(string);
        }
        return null;
    }

    public final void logDebug(String string) {
        if (!m_bInitialized) {
            return;
        }
        if (string.length() >= 65535) {
            this.logCallback(5, 0, string.substring(0, 65534), this.m_nNativeInfo);
        } else {
            this.logCallback(5, 0, string, this.m_nNativeInfo);
        }
    }

    public final void setError(ConnectorReturnCode connectorReturnCode, String string) {
        this.m_eErrorCode = connectorReturnCode;
        this.m_strErrorText = string;
        if (m_bInitialized && string.length() > 0) {
            this.logCallback(2, connectorReturnCode.getCode(), string, this.m_nNativeInfo);
        }
    }

    public final void throwError(ConnectorReturnCode connectorReturnCode, String string) throws ConnectorException {
        this.setError(connectorReturnCode, string);
        throw new ConnectorException(connectorReturnCode, string);
    }

    public final void throwError(ConnectorReturnCode connectorReturnCode, String string, Throwable throwable) throws ConnectorException {
        this.setError(connectorReturnCode, string);
        throw new ConnectorException(connectorReturnCode, string, throwable);
    }

    private final native void logCallback(int var1, int var2, String var3, long var4);
}

