/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import ag.smaser.trip.filefilter.tikasrv.BasicLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.TypeDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.epub.EpubParser;
import org.apache.tika.parser.microsoft.chm.ChmParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.microsoft.rtf.RTFParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.parser.xml.XMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class TikaDriver {
    private ContentHandler contentHandler = null;
    private ParseContext context = null;
    private Parser parser = null;
    private Metadata metadata = null;
    private StringWriter outputWriter = null;
    private InputStream input = null;
    private BasicLogger logger = null;
    private String bodyText = "";
    private Map<String, String> properties = new HashMap<String, String>();
    private static final Map<String, Class> parserMap = new HashMap<String, Class>();

    TikaDriver(String filename, byte[] filedata, String contentType, BasicLogger logger) throws IllegalAccessException, InstantiationException, ReflectiveOperationException {
        this.init(filename, contentType);
        this.input = TikaInputStream.get((byte[])filedata, (Metadata)this.metadata);
    }

    TikaDriver(String filename, InputStream filedata, String contentType, BasicLogger logger) throws IllegalAccessException, InstantiationException, ReflectiveOperationException {
        this.init(filename, contentType);
        this.input = TikaInputStream.get((InputStream)filedata);
    }

    TikaDriver(String filename, File filedata, String contentType, BasicLogger logger) throws IllegalAccessException, InstantiationException, ReflectiveOperationException, IOException {
        this.init(filename, contentType);
        this.input = TikaInputStream.get((Path)filedata.toPath());
    }

    void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.input = null;
        }
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputWriter = null;
        }
        this.parser = null;
        this.metadata = null;
    }

    private void init(String filename, String contentType) throws IllegalAccessException, InstantiationException, ReflectiveOperationException {
        this.metadata = new Metadata();
        if (filename != null && filename.length() > 0) {
            this.metadata.set("resourceName", filename);
        }
        if (contentType != null && contentType.length() > 0) {
            this.metadata.set("Content-Type", contentType);
        }
        if (filename != null && filename.length() > 0) {
            Class parserClass = null;
            int idx = filename.lastIndexOf(46);
            if (idx > 0) {
                parserClass = parserMap.get(filename.substring(idx + 1));
            }
            if (parserClass != null) {
                this.parser = (Parser)parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        if (this.parser == null) {
            AutoDetectParser adp = new AutoDetectParser();
            if (contentType != null && contentType.length() > 0) {
                adp.setDetector((Detector)new TypeDetector());
            }
            this.parser = adp;
        }
        this.outputWriter = new StringWriter();
        this.contentHandler = new BodyContentHandler((Writer)this.outputWriter);
        this.context = new ParseContext();
        this.context.set(Parser.class, (Object)this.parser);
    }

    void setWriter(Writer w) {
        this.outputWriter = null;
        this.contentHandler = new BodyContentHandler(w);
    }

    static void showMediaTypes(String parserClass) throws Exception {
        Parser p = (Parser)Class.forName(parserClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)p);
        for (MediaType mt : p.getSupportedTypes(context)) {
            System.out.println(mt.toString());
        }
    }

    void parse(boolean extractText, boolean extractProperties) throws IOException, SAXException, TikaException {
        this.parser.parse(this.input, this.contentHandler, this.metadata, this.context);
        if (extractText && this.outputWriter != null) {
            this.bodyText = this.outputWriter.toString();
        }
        if (extractProperties) {
            for (String name : this.metadata.names()) {
                this.properties.put(name, this.metadata.get(name));
            }
        }
    }

    String getText() {
        return this.bodyText;
    }

    String[] getPropertyNames() {
        Set<String> keys = this.properties.keySet();
        String[] names = new String[keys.size()];
        keys.toArray(names);
        return names;
    }

    String getProperty(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return "";
    }

    static {
        parserMap.put("pdf", PDFParser.class);
        parserMap.put("docx", OOXMLParser.class);
        parserMap.put("dotx", OOXMLParser.class);
        parserMap.put("xlsx", OOXMLParser.class);
        parserMap.put("xltx", OOXMLParser.class);
        parserMap.put("pptx", OOXMLParser.class);
        parserMap.put("potx", OOXMLParser.class);
        parserMap.put("rtf", RTFParser.class);
        parserMap.put("epub", EpubParser.class);
        parserMap.put("chm", ChmParser.class);
        parserMap.put("xml", XMLParser.class);
        parserMap.put("xsl", XMLParser.class);
        parserMap.put("txt", TXTParser.class);
        parserMap.put("ini", TXTParser.class);
        parserMap.put("odt", OpenDocumentParser.class);
        parserMap.put("fodt", OpenDocumentParser.class);
        parserMap.put("ods", OpenDocumentParser.class);
        parserMap.put("fods", OpenDocumentParser.class);
        parserMap.put("odp", OpenDocumentParser.class);
        parserMap.put("fodp", OpenDocumentParser.class);
        parserMap.put("uop", OpenDocumentParser.class);
        parserMap.put("uot", OpenDocumentParser.class);
        parserMap.put("uos", OpenDocumentParser.class);
    }
}

