/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import ag.smaser.trip.filefilter.tikasrv.BasicLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class NioOutputStream
extends OutputStream {
    private final SocketChannel channel;
    private final ByteBuffer buffer;
    private final Selector selector;
    private final SelectionKey key;
    private boolean isReadyForWrite;
    private final String id;
    private final BasicLogger logger;

    NioOutputStream(SocketChannel channel, BasicLogger logger, String id) throws IOException {
        this.id = id;
        this.logger = logger;
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(32768);
        this.selector = Selector.open();
        this.key = channel.register(this.selector, 4);
        this.isReadyForWrite = false;
    }

    private void write() throws IOException {
        this.logger.extraDebug(this.id, "NioOutputStream.write(" + Integer.toString(this.buffer.limit()) + ")");
        int idling = 0;
        while (idling <= 30000 && this.buffer.remaining() > 0) {
            SocketChannel ch = this.select();
            if (ch == null) {
                idling += 5;
                continue;
            }
            idling = 0;
            this.channel.write(this.buffer);
        }
        if (idling > 30000) {
            throw new IOException("Timeout while waiting for write access to socket");
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.logger.extraDebug(this.id, "NioOutputStream.write(int)");
        ByteBuffer basebuf = this.buffer;
        ((Buffer)basebuf).clear();
        this.buffer.put((byte)b);
        ((Buffer)basebuf).flip();
        this.write();
    }

    @Override
    public void write(byte[] b) throws IOException {
        int chunk;
        this.logger.extraDebug(this.id, "NioOutputStream.write(byte[" + Integer.toString(b.length) + "])");
        ByteBuffer basebuf = this.buffer;
        for (int offset = 0; offset < b.length; offset += chunk) {
            chunk = b.length - offset;
            if (chunk > this.buffer.capacity()) {
                chunk = this.buffer.capacity();
            }
            ((Buffer)basebuf).clear();
            this.buffer.put(b, offset, chunk);
            ((Buffer)basebuf).flip();
            this.write();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int chunk;
        this.logger.extraDebug(this.id, "NioOutputStream.write(byte[" + Integer.toString(b.length) + "]," + Integer.toString(off) + "," + Integer.toString(len) + ")");
        ByteBuffer basebuf = this.buffer;
        for (int offset = off; offset < len; offset += chunk) {
            chunk = len - offset;
            if (chunk > this.buffer.capacity()) {
                chunk = this.buffer.capacity();
            }
            ((Buffer)basebuf).clear();
            this.buffer.put(b, offset, chunk);
            ((Buffer)basebuf).flip();
            this.write();
        }
    }

    private SocketChannel select() throws IOException {
        Iterator<SelectionKey> keys;
        if (this.isReadyForWrite) {
            return this.channel;
        }
        for (int i = 0; i < 6; ++i) {
            if (i == 5) {
                return null;
            }
            if (this.selector.select() != 0) break;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException x) {
                throw new IOException("Thread I/O sleep interrupted", x);
            }
        }
        if ((keys = this.selector.selectedKeys().iterator()).hasNext()) {
            SelectionKey key = keys.next();
            this.logger.extraDebug(this.id, "NioOutputStream.select() -> Socket channel is available for writing");
            this.isReadyForWrite = true;
            return (SocketChannel)key.channel();
        }
        return null;
    }
}

