/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;
    private Buffer basebuf;
    private int markedPosition;
    private int readLimit;

    ByteBufferInputStream(ByteBuffer buf) {
        this.buffer = buf;
        this.basebuf = buf;
        this.basebuf.rewind();
        this.basebuf.position(0);
        this.markedPosition = -1;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.remaining() < 1) {
            return -1;
        }
        if (this.markedPosition > 0 && this.basebuf.position() + 1 > this.markedPosition + this.readLimit) {
            this.markedPosition = -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public long skip(long n) throws IOException {
        int actual = (int)n <= this.available() ? (int)n : this.available();
        this.basebuf.position(this.basebuf.position() + actual);
        return actual;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int actual;
        int n = actual = len <= this.available() ? len : this.available();
        if (actual < 1) {
            return -1;
        }
        this.buffer.get(b, off, actual);
        if (this.markedPosition > 0 && this.basebuf.position() > this.markedPosition + this.readLimit) {
            this.markedPosition = -1;
        }
        return actual;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markedPosition < 0) {
            throw new IOException("Marked position is invalid");
        }
        this.basebuf.position(this.markedPosition);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.readLimit = readlimit;
        this.markedPosition = this.basebuf.position();
    }
}

