#!/bin/sh

#******************************************************************************
# Filename    : showjvm.sh
# Purpose     : Shows the default Java VM library (if any is installed)
# Parameters  : (none)
#*******************************************************************************

findjvmlib()
{
   JVH=$1
   if [ "`uname`" = "Darwin" ]; then
      find $JVH -name '*jvm.dylib'
   else
      find $JVH -name '*jvm.so' | while read jj; do
         JVM=`readlink -f $jj`
         if [ -f "$JVM" ]; then
            echo $JVM
         fi
      done
   fi
}

java_alternatives()
{
   if [ ! -f /usr/sbin/alternatives ]; then
      return
   fi

   /usr/sbin/alternatives --list| grep jvm | awk '{print $3}'|sort -u|while read jd; do
      jv=""
      if [ -f "$jd/release" ]; then
         jv=`grep ^JAVA_VERSION= "$jd/release" | cut -d\" -f2`
      fi
      if [ "$jv" = "" ] && [ -f "$jd/bin/java" ]; then
         jv=`$jd/bin/java -version 2>&1|grep " version "| cut -d\" -f2`
      fi
      if [ "$jv" != "" ]; then
         if [ "1" == "`echo $jv|cut -d\. -f1`" ]; then
            jv=0`echo $jv | cut -d\. -f2-`
         fi
         jvm=`findjvmlib $jd`
         if [ "$jvm" != "" ]; then
            echo "$jv $jvm"
         fi
      fi
   done
}

get_java_home()
{
    JHOME=

    HAS_OPENJDK=0
    if [ "" != "`java -version 2>&1 | grep OpenJDK`" ]; then
        HAS_OPENJDK=1
    fi

    JAVAC=`which javac 2>/dev/null | grep -v "not found"`
    READLINK=`which readlink 2>/dev/null | grep -v "not found"`

    if [ $HAS_OPENJDK -eq 1 ]; then
        
        # Use non-standard argument in OpenJDK to figure out java.home
        JHOME=`java -XshowSettings:properties 2>&1 | grep java.home | cut -d= -f2 | awk '{print $NF}'`

    fi

    if [ "$JHOME" = "" ] && [ "$JAVAC" != "" ]; then

        # Create and run a small java program to print java.home property

        TMPNUM=1
        while [ -d /tmp/$$_$TMPNUM ]; do
            TMPNUM=`expr $TMPNUM + 1`
        done
        
        TMPDIR=/tmp/$$_$TMPNUM
        mkdir $TMPDIR
        JAVAFILE=$TMPDIR/javahome.java

        echo "public class javahome {" > $JAVAFILE
        echo "public static void main(String[] args) { " >> $JAVAFILE
        echo "System.out.println(System.getProperty(\"java.home\").toString()); } } " >> $JAVAFILE

        $JAVAC -d $TMPDIR $JAVAFILE
        if [ $? -eq 0 ]; then
            JHOME=`java -cp $TMPDIR javahome`
        fi

        rm -rf $TMPDIR

    fi
    
    if [ "$JHOME" = "" ] && [ "$READLINK" != "" ]; then

        # Resolve the path to the java command and derive the sought after 
        # value based on the result.

        JAVACMD=`which java 2>/dev/null | grep -v "not found"`
        if [ "$JAVACMD" != "" ]; then
            JHOME=`$READLINK -f $JAVACMD | sed "s:/bin/java::"`
            if [ "$JHOME" != "" ]; then
                if [ ! -d $JHOME ]; then
                    JHOME=""
                fi
            fi
        fi
    fi

    if [ "$JHOME" != "" ]; then
        echo $JHOME
    fi
}

java_scan()
{
   # System configured Java alternatives
   java_alternatives

   # Get current Java if not installed via the system package manager
   JVH=`get_java_home`
   if [ "$JVH" != "" ] && [ -d "$JVH" ]; then
      if [ "`uname`" = "Darwin" ]; then
         find $JVH -name '*jvm.dylib' | while read jj; do
            JVM=`readlink -f $jj`
            if [ -f "$JVM" ]; then
               JVER=`$JVH/bin/java -version 2>&1|grep " version "| cut -d\" -f2`
               echo "$JVER $JVM"
            fi
         done
      else
         find $JVH -name '*jvm.so' | while read jj; do
            JVM=`readlink -f $jj`
            if [ -f "$JVM" ]; then
               JVER=`$JVH/bin/java -version 2>&1|grep " version "| cut -d\" -f2`
               echo "$JVER $JVM"
            fi
         done
      fi
   fi
}


java_scan | sort -ru


