/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import ag.smaser.trip.filefilter.tikasrv.BasicLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class NioInputStream
extends InputStream {
    private final SocketChannel channel;
    private final ByteBuffer buffer;
    private final Selector selector;
    private final SelectionKey key;
    private final String id;
    private boolean moreData;
    private final BasicLogger logger;
    private boolean isReadyForRead;
    private final int timeout = 30000;

    NioInputStream(SocketChannel channel, BasicLogger logger, String id) throws IOException {
        this.logger = logger;
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(32768);
        this.selector = Selector.open();
        this.id = id;
        this.key = channel.register(this.selector, 1);
        this.moreData = true;
        this.isReadyForRead = false;
        ByteBuffer basebuf = this.buffer;
        ((Buffer)basebuf).position(0);
        ((Buffer)basebuf).limit(0);
    }

    public String readHttpHeaderLine() throws IOException {
        this.logger.extraDebug(this.id, "NioInputStream.readHttpHeaderLine()");
        if (!this.moreData) {
            return null;
        }
        boolean isAtEol = false;
        ByteArrayOutputStream line = new ByteArrayOutputStream(1024);
        do {
            if (this.buffer.remaining() < 1 && this.readNextBlock(30000) < 1) {
                if (line.size() == 0) {
                    return null;
                }
                return line.toString("ISO-8859-1");
            }
            int bprev = -1;
            while (!isAtEol && this.buffer.remaining() > 0) {
                byte b = this.buffer.get();
                if (b == 10) {
                    isAtEol = true;
                } else if (bprev != -1) {
                    line.write(bprev);
                }
                bprev = b;
                if (isAtEol || this.buffer.remaining() != 0) continue;
                line.write(b);
            }
        } while (!isAtEol);
        return line.toString("ISO-8859-1");
    }

    @Override
    public int read() throws IOException {
        this.logger.extraDebug(this.id, "NioInputStream.read()");
        if (!this.moreData) {
            return -1;
        }
        if (this.buffer.remaining() < 1 && this.readNextBlock(30000) < 1) {
            return -1;
        }
        return this.buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.logger.extraDebug(this.id, "NioInputStream.read(byte[],int,int)");
        if (this.buffer.remaining() < 1 && this.readNextBlock(30000) < 1) {
            return -1;
        }
        int bytesToCopy = len < this.buffer.remaining() ? len : this.buffer.remaining();
        this.buffer.get(b, off, bytesToCopy);
        this.logger.extraDebug(this.id, "NioInputStream.read(byte[],int,int) ->" + Integer.toString(bytesToCopy));
        return bytesToCopy;
    }

    private int readNextBlock(int timeout) throws IOException {
        this.logger.extraDebug(this.id, "NioInputStream.readNextBlock()");
        ByteBuffer basebuf = this.buffer;
        int idling = 0;
        while (idling <= timeout) {
            SocketChannel ch = this.select();
            if (ch == null) {
                idling += 5;
                continue;
            }
            idling = 0;
            this.logger.extraDebug(this.id, "reading data from socket channel");
            ((Buffer)basebuf).clear();
            int bytesRead = ch.read(this.buffer);
            if (bytesRead == -1) {
                this.logger.warn(this.id, "NioInputStream.readNextBlock() -> -1 returned from channel read");
                this.moreData = false;
            }
            if (bytesRead > 0) {
                this.logger.extraDebug(this.id, "NioInputStream.readNextBlock() -> " + Integer.toString(bytesRead));
                ((Buffer)basebuf).flip();
                return bytesRead;
            }
            if (bytesRead < 0) {
                throw new IOException("Connection reset by peer");
            }
            this.logger.debug(this.id, "NioInputStream.readNextBlock() -> no bytes read (delay in transmission?)");
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException x) {
                throw new IOException("Thread I/O sleep interrupted", x);
            }
        }
        this.moreData = false;
        throw new IOException("Timeout waiting for readable socket");
    }

    private SocketChannel select() throws IOException {
        Iterator<SelectionKey> keys;
        if (this.isReadyForRead) {
            return this.channel;
        }
        for (int i = 0; i < 6; ++i) {
            if (i == 5) {
                return null;
            }
            if (this.selector.select() != 0) break;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException x) {
                throw new IOException("Thread I/O sleep interrupted", x);
            }
        }
        if ((keys = this.selector.selectedKeys().iterator()).hasNext()) {
            SelectionKey key = keys.next();
            this.logger.extraDebug(this.id, "NioInputStream.select() -> Socket channel is available for reading");
            this.isReadyForRead = true;
            return (SocketChannel)key.channel();
        }
        return null;
    }
}

