/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

class BasicLogger {
    static int LEVEL_OFF = 0;
    static int LEVEL_FATAL = 1;
    static int LEVEL_ERROR = 2;
    static int LEVEL_WARN = 3;
    static int LEVEL_INFO = 4;
    static int LEVEL_DEBUG = 5;
    static int LEVEL_EXTRADEBUG = 6;
    private int level = LEVEL_OFF;
    private Writer logwriter = null;
    private SimpleDateFormat sdf;

    BasicLogger(int level) {
        this.level = level;
        this.logwriter = new BufferedWriter(new OutputStreamWriter(System.out));
        this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    BasicLogger(String file, int level) throws IOException {
        this.level = level;
        this.logwriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
    }

    void close() {
        if (this.logwriter != null) {
            try {
                this.logwriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.logwriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logPrint(int level, String id, String msg) {
        block8: {
            String[] label = new String[]{"", "FATAL", "ERROR", " WARN", " INFO", "DEBUG", "EXTRA"};
            int nlevel = level >= 0 ? (level <= 6 ? level : 6) : 0;
            try {
                if (nlevel > this.level) break block8;
                BasicLogger basicLogger = this;
                synchronized (basicLogger) {
                    Date now = new Date();
                    this.logwriter.write("[" + this.sdf.format(now) + " " + label[nlevel] + "] ");
                    if (id != null && id.length() > 0) {
                        this.logwriter.write(id);
                        this.logwriter.write(": ");
                    }
                    this.logwriter.write(msg);
                    if (!msg.endsWith("\n")) {
                        this.logwriter.write("\n");
                    }
                    if (this.level >= LEVEL_INFO) {
                        this.logwriter.flush();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void logPrint(int level, String id, Throwable x) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        x.printStackTrace(pw);
        this.logPrint(level, id, sw.getBuffer().toString());
    }

    boolean isActive(int level) {
        int nlevel = level >= 0 ? (level <= 5 ? level : 5) : 0;
        return nlevel <= this.level;
    }

    void fatal(String id, Throwable x) {
        this.logPrint(LEVEL_FATAL, id, x);
    }

    void error(String id, Throwable x) {
        this.logPrint(LEVEL_ERROR, id, x);
    }

    void warn(String id, Throwable x) {
        this.logPrint(LEVEL_WARN, id, x);
    }

    void fatal(String id, String msg) {
        this.logPrint(LEVEL_FATAL, id, msg);
    }

    void error(String id, String msg) {
        this.logPrint(LEVEL_ERROR, id, msg);
    }

    void warn(String id, String msg) {
        this.logPrint(LEVEL_WARN, id, msg);
    }

    void info(String id, String msg) {
        this.logPrint(LEVEL_INFO, id, msg);
    }

    void debug(String id, String msg) {
        this.logPrint(LEVEL_DEBUG, id, msg);
    }

    void extraDebug(String id, String msg) {
        this.logPrint(LEVEL_EXTRADEBUG, id, msg);
    }
}

