/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter.tikasrv;

import ag.smaser.trip.filefilter.tikasrv.BasicLogger;
import ag.smaser.trip.filefilter.tikasrv.NioClientRequest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NioServer
extends Thread {
    private ServerSocketChannel channel;
    SelectionKey socketServerSelectionKey;
    private Selector selector;
    private final BasicLogger logger;
    private final ExecutorService threadPool;
    private int maxFileSize = 20000000;
    private String logid = "LISTENER";
    static final int STATE_ACCEPT = 0;
    static final int STATE_READ_COMMAND = 1;
    static final int STATE_READ_DATA = 2;
    static final int STATE_WRITE_HEADER = 3;
    static final int STATE_SEND_FILE = 4;
    static final int STATE_CANCEL = 99;

    NioServer(BasicLogger logger, int port, int maxworkers) throws IOException {
        this.logger = logger;
        this.channel = ServerSocketChannel.open();
        this.channel.bind(new InetSocketAddress("localhost", port));
        this.channel.configureBlocking(false);
        this.selector = Selector.open();
        this.socketServerSelectionKey = this.channel.register(this.selector, 16);
        this.threadPool = Executors.newFixedThreadPool(maxworkers);
        logger.info(this.logid, "SimpleServer initialized with a pool of " + Integer.toString(maxworkers) + " worker threads.");
    }

    void close() throws InterruptedException {
        this.logger.info(this.logid, "NIOServer clearing away used system resources");
        if (this.selector != null && this.channel != null) {
            try {
                this.logger.debug(this.logid, "Closing listener socket");
                this.selector.close();
                this.channel.close();
            }
            catch (IOException ignore) {
                this.logger.warn(this.logid, ignore);
            }
            this.selector = null;
            this.channel = null;
        }
        this.threadPool.shutdownNow();
    }

    void setMaxFileSize(int sz) {
        this.maxFileSize = sz;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            block4: while (true) {
                if (this.selector.select(5L) == 0) {
                    continue;
                }
                selectedKeys = this.selector.selectedKeys();
                iterator = selectedKeys.iterator();
                while (true) {
                    if (iterator.hasNext()) ** break;
                    continue block4;
                    key = iterator.next();
                    if (key.isAcceptable()) {
                        listener = (ServerSocketChannel)key.channel();
                        client = listener.accept();
                        r = new NioClientRequest(client, this.logger, this.maxFileSize);
                        this.threadPool.execute(r);
                    }
                    iterator.remove();
                }
                break;
            }
        }
        catch (Exception x) {
            this.logger.fatal(this.logid, x);
            try {
                this.close();
            }
            catch (Exception var1_3) {
                // empty catch block
            }
            this.logger.info(this.logid, "NioServer listener thread exiting.");
            return;
        }
    }
}

