/*
 * Decompiled with CFR 0.152.
 */
package ag.smaser.trip.filefilter;

import ag.smaser.trip.filefilter.AdapterOutputType;
import ag.smaser.trip.filefilter.Conversion;
import ag.smaser.trip.filefilter.ConvertAbility;
import ag.smaser.trip.filefilter.FileFilterException;
import ag.smaser.trip.filefilter.FilterReturnCode;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class FilterAdapter {
    private FilterReturnCode m_eErrorCode = FilterReturnCode.Success;
    private String m_strErrorText = "";
    private Charset m_enc = null;
    private Hashtable<String, String> m_properties = new Hashtable();
    private long m_nNativeInfo = 0L;
    private static boolean m_bInitialized = false;
    private ArrayList<String> m_hitWords = new ArrayList();

    protected FilterAdapter() {
        try {
            this.setConvertTextEncoding("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeAdapter(long l) throws FileFilterException {
        try {
            this.m_nNativeInfo = l;
            System.loadLibrary("fifi_jni_callback");
        }
        catch (Exception exception) {
            this.throwError(FilterReturnCode.InitializationError, "Could not load Java native library for FIFI callbacks.", exception);
        }
        this.setError(FilterReturnCode.Success, "");
        m_bInitialized = true;
    }

    public void uninitializeAdapter() throws FileFilterException {
        this.setError(FilterReturnCode.Success, "");
        m_bInitialized = false;
    }

    public ConvertAbility checkConversion(AdapterOutputType adapterOutputType, String string) throws FileFilterException {
        this.setError(FilterReturnCode.Success, "");
        return ConvertAbility.No;
    }

    public abstract void openConversion(Conversion var1) throws FileFilterException;

    public abstract void closeConversion(Conversion var1) throws FileFilterException;

    public abstract void convert(Conversion var1, String var2) throws FileFilterException;

    public final int getLastConversionErrorCode() {
        return this.m_eErrorCode.getCode();
    }

    public final String getLastConversionError() {
        return this.m_strErrorText;
    }

    public final void setConvertTextEncoding(String string) throws FileFilterException {
        try {
            this.m_enc = Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            this.setError(FilterReturnCode.InvalidArgument, illegalCharsetNameException.toString());
            throw new FileFilterException(FilterReturnCode.InvalidArgument, "Unable to assign text encoding (illegal).", illegalCharsetNameException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            this.setError(FilterReturnCode.InvalidArgument, unsupportedCharsetException.toString());
            throw new FileFilterException(FilterReturnCode.InvalidArgument, "Unable to assign text encoding (unsupported).", unsupportedCharsetException);
        }
        catch (Exception exception) {
            this.setError(FilterReturnCode.Unknown, exception.toString());
            throw new FileFilterException(FilterReturnCode.InvalidArgument, "Unable to assign text encoding.", exception);
        }
    }

    public final Charset getConvertTextEncoding() {
        return this.m_enc;
    }

    public final void setAdapterProperty(String string, String string2) throws FileFilterException {
        this.setError(FilterReturnCode.Success, "");
        try {
            this.m_properties.put(string, string2);
            this.logDebug("ADAPTERPROPERTY \"" + string + "\" := \"" + string2 + "\"");
        }
        catch (Exception exception) {
            this.setError(FilterReturnCode.Unknown, exception.toString());
            throw new FileFilterException(this.m_eErrorCode, "Unable to assign adapter property.", exception);
        }
    }

    public final boolean hasAdapterProperty(String string) {
        return this.m_properties.containsKey(string);
    }

    public final String getAdapterProperty(String string) {
        if (this.hasAdapterProperty(string)) {
            return this.m_properties.get(string);
        }
        return null;
    }

    public final List<String> getHitWords() {
        return this.m_hitWords;
    }

    public final boolean hasHitWord(String string) {
        for (String string2 : this.m_hitWords) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public final boolean applyHighlighting() {
        return this.m_hitWords.size() > 0;
    }

    public final void logDebug(String string) {
        if (!m_bInitialized) {
            return;
        }
        if (string.length() >= 65535) {
            this.logCallback(5, 0, string.substring(0, 65534), this.m_nNativeInfo);
        } else {
            this.logCallback(5, 0, string, this.m_nNativeInfo);
        }
    }

    public final void setError(FilterReturnCode filterReturnCode, String string) {
        this.m_eErrorCode = filterReturnCode;
        this.m_strErrorText = string;
        if (m_bInitialized && string.length() > 0) {
            this.logCallback(2, filterReturnCode.getCode(), string, this.m_nNativeInfo);
        }
    }

    public final void throwError(FilterReturnCode filterReturnCode, String string) throws FileFilterException {
        this.setError(filterReturnCode, string);
        throw new FileFilterException(filterReturnCode, string);
    }

    public final void throwError(FilterReturnCode filterReturnCode, String string, Throwable throwable) throws FileFilterException {
        this.setError(filterReturnCode, string);
        throw new FileFilterException(filterReturnCode, string, throwable);
    }

    public final void addHitWord(Conversion conversion, String string) {
        this.logDebug("Java Adapter: registering hit word \"" + string + "\"");
        this.m_hitWords.add(string);
    }

    public final void addConversionResult(String string, String string2, Conversion conversion, byte[] byArray) {
        long l = 0L;
        if (null != conversion) {
            l = conversion.getUserData();
        }
        if (null != byArray) {
            this.conversionCallback(string, string2, byArray, byArray.length, l);
        }
    }

    public final void addConversionResult(String string, String string2, Conversion conversion, byte[] byArray, int n) {
        long l = 0L;
        if (null != conversion) {
            l = conversion.getUserData();
        }
        if (null != byArray) {
            this.conversionCallback(string, string2, byArray, n < byArray.length ? n : byArray.length, l);
        }
    }

    public final void addConversionResult(String string, String string2, Conversion conversion, String string3) {
        long l = 0L;
        if (null != conversion) {
            l = conversion.getUserData();
        }
        byte[] byArray = string3.getBytes(this.m_enc);
        this.conversionCallback(string, string2, byArray, byArray.length, l);
    }

    public final void addConversionResult(Conversion conversion, byte[] byArray) {
        long l = 0L;
        if (null != conversion) {
            l = conversion.getUserData();
        }
        if (null != byArray) {
            this.conversionCallback("text/plain", "", byArray, byArray.length, l);
        }
    }

    public final void addConversionResult(Conversion conversion, byte[] byArray, int n) {
        long l = 0L;
        if (null != conversion) {
            l = conversion.getUserData();
        }
        if (null != byArray) {
            this.conversionCallback("text/plain", "", byArray, n < byArray.length ? n : byArray.length, l);
        }
    }

    public final void addConversionResult(Conversion conversion, String string) {
        long l = 0L;
        if (null != conversion) {
            l = conversion.getUserData();
        }
        byte[] byArray = string.getBytes(this.m_enc);
        this.conversionCallback("text/plain", "", byArray, byArray.length, l);
    }

    public final void addExtractedProperty(Conversion conversion, String string, String string2) {
        long l = 0L;
        if (null != conversion) {
            l = conversion.getUserData();
        }
        this.propertyCallback(string, string2, l);
    }

    private final native void propertyCallback(String var1, String var2, long var3);

    private final native void conversionCallback(String var1, String var2, Object var3, int var4, long var5);

    private final native void logCallback(int var1, int var2, String var3, long var4);
}

